// Faca um programa para simular o jogo FORCA.
// O programa devera solicitar uma palavra e permitir que o
// qjogador tente acertar a palavra indicando caracter de 
// forma que se o jogador errar mais que 06 vezes, perde o jogo.
// Os caracteres totais e a posicao dos caracteres acertados 
// deverao ficar visiveis ao jogador

// *** USANDO FUNCAO ***

// Exemplo: - palavra digitada SISTEMAS

// +--------------------------------------------+
// | Letras jogadas: A, O, S                    |
// |                                            |
// |  S       S               A   S             |
// | ___ ___ ___ ___ ___ ___ ___ ___            |
// |                                            |
// | Erros: 1                                   |
// |                                            |
// +--------------------------------------------+

//Cristian Bueno RA - 502.895/7

#include <stdafx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include "tool.h"

char* digita (void);
void monta_tela(int tamanho);
char digita_letra(int jogada, int jogadax, char letra[50]);
void jogada_errada (int erro, int jogadax);
int jogada_certa (int acerto, char letra_atual, int tamanho, char palavra[21], int jogadax);
void ganhou (void);
char jogar_novamente (void);

int main()
{
	char palavra[21], letra[50], sair;
	int jogada, erro, acerto, tamanho;
	int jogadax;

	do
	{
		system ("cls");
		sair=' ';
		strcpy(palavra, digita());			// solicitando palavra para inicio do jogo
		flushall ();						// limpando cache do teclado para no influenciar no resultado
		system ("cls");
		tamanho=strlen(palavra);			// montando tela
		monta_tela(tamanho);				// funcao que monta a tela para exibicao
		erro=0;								// definindo parametros para comecar o jogo
		acerto=0;
		for (jogada=0; erro<6 && acerto<=tamanho; jogada++)
		{
			
			jogadax=(jogada+1)*2+15;			// posicionando cursor para digitar letra. Calcula para reposicionar a cada jogada
			flushall ();						// limpando cache do teclado para no influenciar no resultado
			letra[jogada]=digita_letra(jogada, jogadax, letra);			//solicitando letras
			if (strchr(palavra,letra[jogada])==0)
			{
				erro=erro+1;
				jogada_errada (erro, jogadax);	// funcao caso tenha errado a letra at a FORCA
			}
			else
			{
				acerto=jogada_certa (acerto, letra[jogada], tamanho, palavra, jogadax);	// funcao caso tenha acertado a letra
			}
			if (acerto==tamanho)
			{
				ganhou();						// funcao criada para mostrar que jogador ganhou
				break;
			}
		}

		sair=jogar_novamente();

	}while (sair == 'S' || sair == 's');

	gotoxy(1,23);
	printf ("\n");
	return 0;
}

char jogar_novamente (void)
{
	char sair;

	do
	{
		gotoxy(1,23);
		printf ("\n");
		printf ("Deseja jogar novamente? ");
		sair=getche ();
	}while (sair != 'S' && sair!='s' && sair != 'n' && sair != 'N');

	return sair;
}


void ganhou (void)
{
		gotoxy(14,14);
		printf (" ***   ***  *  ** ** **  ***  ** **  **");
		gotoxy(14,15);
		printf ("** ** ** ** ** ** ** ** ** ** ** **  **");
		gotoxy(14,16);
		printf ("**    ** ** ***** ** ** ** ** ** **  **");
		gotoxy(14,17);
		printf ("***** ***** ***** ***** ** ** ** **  **");
		gotoxy(14,18);
		printf ("** ** ***** ***** ***** ** ** ** **  **");
		gotoxy(14,19);
		printf ("** ** ** ** ** ** ** ** ** ** *****");
		gotoxy(14,20);
		printf (" ***  ** ** **  * ** **  ***   ***   **");
}

int jogada_certa (int acerto, char letra_atual, int tamanho, char palavra[21], int jogadax)
{
	int onde;

	for (onde=0;onde<=tamanho;onde++)
	{
		// Se a posio da String for igual ao caracter
		if (palavra[onde] == letra_atual)
		{
			gotoxy((onde+1)*2,5);
			printf ("%c", letra_atual);
			acerto=acerto+1;
		}

	}
	gotoxy(jogadax+1,3);
	printf (",");
	
	return acerto;
}

char* digita (void)
{
	char palavra[40];
	int tamanho;
	do
	{
		printf ("\n\n\nDigite palavra (20 LETRAS): ");
		gets (palavra);
		tamanho = strlen(palavra);  //limitando o tamanho da palavra
		if (tamanho>20)
		{
			printf ("\n\nPalavra muito grande! Digite novamente\n\n");

		}

	}while(tamanho>20);

		return palavra;
}

void monta_tela (int tamanho)
{
	int contador;
	gotoxy(1,3);
	printf ("Letras jogadas: ");

	//preenchendo espacos das letras
	for(contador=0; contador<tamanho; contador ++)
	{
		gotoxy((contador+1)*2,6);
		printf ("_");
	}
	gotoxy(0,9);
	printf ("Erros: ");
	gotoxy(0,12);
	printf ("+--/---+\n");
	printf ("| /    |\n");
	printf ("|/\n");
	printf ("|\n");
	printf ("|\n");
	printf ("|\n");
	printf ("|\n");
	printf ("|\n");
	printf ("|\n");
	printf ("----------\n");
}

char digita_letra (int jogada, int jogadax, char letra [50])
{
	char letra_atual;
	int validaletra;


	do
	{
		gotoxy(jogadax,3);
		letra_atual=getche();
		for (validaletra=jogada; validaletra>=0;validaletra--)
		{
			if (letra_atual == letra[validaletra-1] || letra_atual == ' ')
			{
				gotoxy (0,23);
				printf ("*** LETRA REPETIDA * DIGITE NOVAMENTE ***");
				letra_atual = '*'; 
			}
		}
	//condicao para nao repetir letra
	}while (letra_atual=='*');
	
	gotoxy (0,23);
	printf ("                                                ");
	return letra_atual;
}

void jogada_errada (int erro, int jogadax)
{
				gotoxy(jogadax+1,3);
				printf (",");
				gotoxy(9,9);
				printf ("%d", erro);
				switch (erro)
				{
				case 1:
					gotoxy(5,14);
					printf ("(o o)");
					break;
				case 2:
					gotoxy(7,15);
					printf ("|");
					gotoxy(7,16);
					printf ("|");
					gotoxy(7,17);
					printf ("_");
					break;
				case 3:
					gotoxy(6,15);
					printf ("/");
					gotoxy(5,16);
					printf ("/");
					break;
				case 4:
					gotoxy(8,15);
					printf ("\\");
					gotoxy(9,16);
					printf ("\\");
					break;
				case 5:
					gotoxy(6,17);
					printf ("|");
					gotoxy(6,18);
					printf ("|");
					break;
				case 6:
					gotoxy(5,14);
					printf ("(x x)");
					gotoxy(8,17);
					printf ("|");
					gotoxy(8,18);
					printf ("|");
					gotoxy(14,14);
					printf ("***** ***** ***    ***   ***    **");
					gotoxy(14,15);
					printf ("***** ***** ** ** ** ** *****   **");
					gotoxy(14,16);
					printf ("**    ** ** ** ** **    ** **   **");
					gotoxy(14,17);
					printf ("***   ** ** ** ** **    ** **   **");
					gotoxy(14,18);
					printf ("***   ** ** ***   **    *****   **");
					gotoxy(14,19);
					printf ("**    ***** ** ** ** ** *****");
					gotoxy(14,20);
					printf ("**    ***** ** **  ***  ** **   **");
					break;
				}
}
