// Faca um programa para Jogo Batalha Naval
// Matrix		6 X 6
// Erros		5
// Nos. barcos	5
// Acertos		1
// Mostra as jogadas, acertos, erros, porcentagem restante, jogada atual.

#include	"stdafx.h"
#include	"tool.h"
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<conio.h>
#define		random(x) (rand() % x)

int		posicao[6][6];

char*	digita_jogada		(void);
char	jogar_novamente		(void);
int		mostrar_jogada		(char jogada [3]);
int		posicionamento_jogada(char jogada[3]);
int		verificar_jogada	(char jogada[3]);
void	acrescentar_jogada	(int numero_jogada, char jogada[3]);
void	definir_barcos		(void);
void	montar_tela			(void);
void	msg_opcao_invalida	(char mensagem[20]);
void	msg_perdeu			(void);
void	msg_proxima_jogada	(void);
void	msg_venceu			(void);


int main()
{
	char	sair, jogada [3], mensagem [20];
	int		total, valida_jogada, erro, acerto, numero_jogada, erro_acerto;
	
	do
	{
		// parametros iniciais
		erro=0;
		acerto=0;
		total=0;
		numero_jogada=1;
		system ("cls");

		montar_tela();			// montar tela do joga
		definir_barcos();		// definindo aleatoriamente a posicao dos barcos
		
		do
		{
			do
			{
				strcpy (jogada, digita_jogada());			// solicitado jogada
				valida_jogada=verificar_jogada(jogada);
				if (valida_jogada==0)
				{
					strcpy (jogada," \0");
					strcpy(mensagem,"JOGADA REPETIDA");
					msg_opcao_invalida(mensagem);
				}
			}while (valida_jogada==0);

			erro_acerto=mostrar_jogada(jogada);		
			if (erro_acerto==0)
			{
				erro=erro+1;
				gotoxy (46,11);
				printf ("%d", erro);
				if (erro==31)
				{
					msg_perdeu ();
					break;
				}
			}
			if (erro_acerto==1)
			{
				acerto=acerto+1;
				gotoxy (46,9);
				printf ("%d", acerto);
				gotoxy (46,13);
				printf ("%d", (5-acerto));
				if (acerto==5)
				{
					msg_venceu();
					break;
				}
			}

			acrescentar_jogada(numero_jogada, jogada);

			numero_jogada=numero_jogada+1;
			total=acerto+erro;

		}while (total<36);

		gotoxy (1,23);
		sair=jogar_novamente();
		gotoxy (20,23);

	}while (sair == 'S' || sair == 's');
	return 0;
}

int verificar_jogada(char jogada[3])
{
	int linha, valida_jogada;
	linha=posicionamento_jogada(jogada);
	if (posicao[linha][jogada[1]-49]==2)
	{
		valida_jogada=0;
	}
	else
	{
		valida_jogada=1;
	}

	return valida_jogada;
}

void acrescentar_jogada (int numero_jogada, char jogada[3])			// Funcao que acrescenta jogada na lista existente
{
	int jogada_x, jogada_y;

	if (numero_jogada<=15)
	{
		jogada_x=((numero_jogada*4)+18);
		jogada_y=15;
	}
	else
	{
		jogada_x=(((numero_jogada-15)*4)-2);
		jogada_y=16;
	}
	gotoxy (jogada_x,jogada_y);
	printf ("%s, ", jogada);
}

void msg_perdeu (void)
{
	HANDLE  screen;								
	screen = GetStdHandle(STD_OUTPUT_HANDLE);	
	SetConsoleTextAttribute(screen,14);			

	gotoxy (30,8);
	printf ("                                               ");
	
	gotoxy (0,18);
	printf ("  #  #  ##  #   #  #  ##  #   #  #  ##  #     ###  #### ###  ###  #### #  # # \n");
	printf ("  #  # #  # #   #  # #  # #   #  # #  # #     #  # #    #  # #  # #    #  # # \n");
	printf ("  #### #  # #   #### #  # #   #### #  # #     ###  ##   #  # #  # ##   #  # # \n");
	printf ("  #  # ####     #  # ####     #  # ####       #    #    ###  #  # #    #  #   \n");
	printf ("  #  # #  # #   #  # #  # #   #  # #  # #     #    #### #  # ###  #### #### # \n");

	SetConsoleTextAttribute(screen,15);			
}

void msg_venceu (void)
{
	HANDLE  screen;								
	screen = GetStdHandle(STD_OUTPUT_HANDLE);	
	SetConsoleTextAttribute(screen,14);			

	gotoxy (30,8);
	printf ("                                               ");

	gotoxy (0,18);
	printf ("  #  #  ##  #  # #  ##   ###   ###  ####  ### #### ###  #  # # ###   ##   ### \n");
	printf ("  ## # #  # #  # # #  # #      #  # #    #     #   #  # #  # # #  # #  # #    \n");
	printf ("  #### #  # #  # # #  #  ##    #  # ##    ##   #   #  # #  # # #  # #  #  ##  \n");
	printf ("  # ## ####  ##  # #  #    #   #  # #       #  #   ###  #  # # #  # #  #    # \n");
	printf ("  #  # #  #  ##  #  ##  ###    ###  #### ###   #   #  # #### # ###   ##  ###  \n");

	SetConsoleTextAttribute(screen,15);			
}

int mostrar_jogada (char jogada[3])
{
	int linha, erro_acerto;

	linha=posicionamento_jogada(jogada);
	if (posicao[linha][jogada[1]-49]==0)
	{
		HANDLE  screen;								
		screen = GetStdHandle(STD_OUTPUT_HANDLE);	
		SetConsoleTextAttribute(screen,9);			

		printf ("~~~");
		erro_acerto=0;
		posicao[linha][jogada[1]-49]=2;

		SetConsoleTextAttribute(screen,15);			
	}
	else	
	{
		HANDLE  screen;								
		screen = GetStdHandle(STD_OUTPUT_HANDLE);	
		SetConsoleTextAttribute(screen,12);			

		printf ("\\P/");
		erro_acerto=1;
		posicao[linha][jogada[1]-49]=2;

		SetConsoleTextAttribute(screen,15);			
	}
	return erro_acerto;
}

int posicionamento_jogada(char jogada[3])
{
	int x, y, linha;
	switch (jogada[0])
	{
	case 'A': 
		y=3; 
		linha=0;
		break;
	case 'B': 
		y=5; 
		linha=1;
		break;
	case 'C': 
		y=7; 
		linha=2;
		break;
	case 'D': 
		y=9;
		linha=3;
		break;
	case 'E': 
		y=11;
		linha=4;
		break;
	case 'F': 
		y=13; 
		linha=5;
		break;
	}
	
	switch (jogada[1])
	{
	case '1': 
		x=4; 
		break;
	case '2': 
		x=8; 
		break;
	case '3': 
		x=12; 
		break;
	case '4': 
		x=16;
		break;
	case '5': 
		x=20;
		break;
	case '6': 
		x=24; 
		break;
	}
	gotoxy (x,y);
	return linha;
}

char* digita_jogada (void)
{
	char jogada [50], mensagem[20];
	int validade;
	
	do
	{
		validade=0;
		gotoxy (46,5);
		printf ("                     ");
		gotoxy (46,5);
		gets (jogada);

		if (jogada[0]<'A' || jogada [0]>'F')
		{
			validade=0;
			strcpy (jogada," \0");
			strcpy(mensagem,"LETRA INVALIDA ");
			msg_opcao_invalida(mensagem);
		}
		if (jogada[0]>='A' && jogada [0]<='F')
		{
			validade=1;
			msg_proxima_jogada();
			if (jogada[1]<'1' || jogada [1]>'6')
			{
				validade=0;
				strcpy (jogada," \0");
				strcpy(mensagem,"NUMERO INVALIDO");
				msg_opcao_invalida(mensagem);
			}
			if (jogada[1]>='1' && jogada [1]<='6')
			{
				validade=1;
				msg_proxima_jogada();
			}
		}
		if (strlen(jogada)>2)
		{
			strcpy(mensagem,"SO LETRA e Num.");
			msg_opcao_invalida(mensagem);
		}

	}while (strlen(jogada)>2 || validade==0);

	return jogada;
}

void msg_opcao_invalida (char mensagem[20])			//mensagem exibida quando digitado posicao INVALIDA
{
	HANDLE  screen;								
	screen = GetStdHandle(STD_OUTPUT_HANDLE);	
	SetConsoleTextAttribute(screen,14);			
	
	gotoxy (30,7);
	printf ("<*< %s! DIGITE NOVAMENTE (A1) >*>", mensagem);
	
	SetConsoleTextAttribute(screen,15);			
}

void msg_proxima_jogada (void)			//mensagem exibida solicitado nova JOGADA
{
	HANDLE  screen;								
	screen = GetStdHandle(STD_OUTPUT_HANDLE);	
	SetConsoleTextAttribute(screen,15);			
	
	gotoxy (30,7);
	printf ("<<<       DIGITE JOGADA (Exemplo: A1)      >>>");
}

void definir_barcos (void)			//funcao que escolhe aleatoriamente a posicao dos barcos
{
	int linha, coluna, contador;
	
	for (linha=0; linha<6; linha++)
	{
		for (coluna=0; coluna<6; coluna++)
		{
			posicao[linha][coluna]=0;
		}
	}
	for (contador=1;contador<6;contador++)
	{
		do
		{
			linha=random(6);
			coluna=random(6);
		}while (posicao[linha][coluna]!=0);

		posicao[linha][coluna]=1;
	}
}

void montar_tela (void)			//funcao para montar a tela do jogo
{
	int x, y, numero, letra;
	HANDLE  screen;								
	screen = GetStdHandle(STD_OUTPUT_HANDLE);	
	SetConsoleTextAttribute(screen,15);			

	numero=1;					// Definindo colunas
	for (x=5; x<=25; x=x+4)
	{
		gotoxy (x,1);
		printf ("%d", numero);
		numero++;
	}

	letra='A';					// Definindo linhas
	for (y=3; y<=14; y=y+2)
	{
		gotoxy (1,y);
		printf ("%c", letra);
		letra++;
	}

	for (numero=1; numero<=7; numero++)		// Desenhando tabela
	{
		y=(numero*2);
		gotoxy (3,y);
		printf ("+---+---+---+---+---+---+");
		
		y=(numero*2)+1;
		gotoxy (3,y);
		if (numero <7)
		{
			printf ("|   |   |   |   |   |   |");
		}
	}

	gotoxy (30,2);
	printf ("    * * * B A T A L H A   N A V A L * * *");
	gotoxy (30,3);
	printf ("       Desenvolvido por CRISTIAN BUENO");
	gotoxy (30,5);
	printf ("PROXIMA JOGADA:");
	msg_proxima_jogada();
	gotoxy (30,9);
	printf ("Acertos       : 0");
	gotoxy (30,11);
	printf ("Agua          : 0");
	gotoxy (30,13);
	printf ("Frota restante: 5 navios");
	gotoxy (1,15);
	printf ("Jogadas Realizadas: ");
	gotoxy (1,23);
	printf ("            Para SAIR a qualquer momento. Pressione 'CRTL+C'");
}

char jogar_novamente (void)			// funcao para sair do sistema
{
	char sair;
	do
	{
		gotoxy(1,23);
		printf ("                                                               ");
		gotoxy(1,23);
		printf ("Deseja jogar novamente? ");
		sair=getche ();
	}while (sair != 'S' && sair!='s' && sair != 'n' && sair != 'N');
	return sair;
}