/*
	Programa que faz comparativo de tempo usando todas as forma de organizao
*/

#include<time.h>
#include<conio.h>
#include<stdio.h>
#include<stdlib.h>

#define TAM 15

// prototipos
void 	criar_vetor_aleatorio (int [], int, int);
void 	mostrar_vetor (int [], int);
void	organizar_bubblesort (int [], int);
void	organizar_selectionsort (int [], int);
void	organizar_insertsort (int [], int);
void	organizar_quicksort (int [], int, int);

int main(void)
{
    int vetor[TAM], vetorBS[TAM], vetorSS[TAM], vetorIS[TAM], vetorQS[TAM], numero, cont;
    clrscr();

    criar_vetor_aleatorio (vetor, TAM, 100);
    for (cont=0; cont<TAM; cont++)
    {
		vetorBS[cont]=vetor[cont];
		vetorSS[cont]=vetor[cont];
		vetorIS[cont]=vetor[cont];
		vetorQS[cont]=vetor[cont];
    }

   	clrscr ();
   	printf ("vetor\n");mostrar_vetor (vetor, TAM);
	
	organizar_bubblesort (vetorBS, TAM);
   	printf ("vetor Buble Sort - organizado\n");mostrar_vetor (vetorBS, TAM);

	organizar_selectionsort (vetorSS, TAM);
    printf ("vetor Selection Sort - organizado\n");mostrar_vetor (vetorSS, TAM);

	printf("Continuar...");
	getch(); clrscr();
   	printf ("vetor\n");mostrar_vetor (vetor, TAM);

	organizar_insertsort (vetorIS, TAM);
    printf ("vetor Isert Sort - organizado\n");mostrar_vetor (vetorIS, TAM);

	organizar_quicksort (vetorQS, 0, TAM-1);
	printf ("vetor Quick Sort - organizado\n");mostrar_vetor (vetorQS, TAM);
	getch();

    return 0;
}

// funcao para preencher um vetor de inteiros com numeros randomicos
void criar_vetor_aleatorio  (int vetor[], int tamanho, int range)
{
    int cont=0;
    srand( time(0) );
	for (cont=0; cont<tamanho; cont++)
	{
		vetor[cont]= rand()%range;
	}
    return;
}

// funcao para exibir conteudo do vetor
void mostrar_vetor(int vetor[], int tamanho)
{
    int cont;
    
	for (cont=0; cont< tamanho; cont++) printf ("----+");
    printf("\n|");
    for (cont=0; cont< tamanho; cont++) printf (" %02d |", cont);
    printf("\n+");
	for (cont=0; cont< tamanho; cont++) printf ("----+");
    printf("\n|");
	for (cont=0; cont< tamanho; cont++) printf (" %02d |", vetor[cont]);
    printf("\n+");
    for (cont=0; cont< tamanho; cont++) printf ("----+");
    printf("\n\n");
    return;
}

//Organizando vetor usando o mtodo Bubble Sort
void	organizar_bubblesort (int vetor[], int tamanho)
{
	int esq, dir, auxiliar;
	for (esq=0; esq < tamanho; esq++)
	{
		for (dir=tamanho-1; dir>esq; dir--)
		{
			if (vetor[dir-1] > vetor[dir])
			{
 				auxiliar 	= vetor[dir];
				vetor[dir] 	= vetor[dir-1];
				vetor[dir-1]= auxiliar;
			}
		}
	}
}

// organizar o vetor em modo Insert Sort
void	organizar_insertsort (int vetor[], int tamanho)
{
	int cont1, cont2, auxiliar;

	for(cont1=0; cont1<tamanho; cont1++)
	{
		auxiliar=vetor[cont1];
		cont2=cont1-1;
		while (cont2>=0 && auxiliar<vetor[cont2])
		{
			vetor[cont2+1]=vetor[cont2];
			cont2--;
		}
		vetor[cont2+1]=auxiliar;
	}
}

// organizar o vetor em modo Selection Sort
void	organizar_selectionsort (int vetor[], int tamanho)
{
	int cont1, cont2, aux1, aux2;
	
	for(cont1=0; cont1<tamanho-1; cont1++)
	{
		aux1=cont1;
		aux2=vetor[cont1];
		for(cont2=cont1+1; cont2<tamanho; cont2++)
		{
			if ( vetor[cont2] < aux2)
			{
				aux1=cont2;
				aux2=vetor[cont2];
			}
		}
		vetor[aux1]=vetor[cont1];
		vetor[cont1]=aux2;
	}
}

//Organizando vetor usando o mtodo Quick Sort
void	organizar_quicksort (int V[], int iBaixo, int iAlto)
{
   int iP, iB, iA, iPivot;
   iB     = iBaixo;
   iA     = iAlto;
   iPivot = V[iBaixo];
   while (iBaixo < iAlto) {
      while ((V[iAlto] >= iPivot) && (iBaixo < iAlto)) {
         iAlto--;
      }
      if (iBaixo  != iAlto) {
         V[iBaixo] = V[iAlto];
         iBaixo++;
      }
      while ((V[iBaixo] <= iPivot) && (iBaixo < iAlto)){
          iBaixo++;
      }
      if (iBaixo != iAlto) {
         V[iAlto] = V[iBaixo];
         iAlto--;
      }
   }
   V[iBaixo] = iPivot;
   iP        = iBaixo;
   iBaixo    = iB;
   iAlto     = iA;
   if (iBaixo < iP) organizar_quicksort(V, iBaixo, iP - 1);
   if (iAlto  > iP) organizar_quicksort(V, iP + 1, iAlto);
   return;
}








// Programa desenvolvido por Cristian Bueno - RA 502.895/7 - 3 Semestre