-- abd_CCDES#1 - Tabelas

use master
set dateformat mdy
go

create 	database [CCDES]
go

use CCDES
go

create table
Cliente
	(
	cd_cliente		integer 	not null	Identity(1,1),
	nm_cliente		varchar(255)	not null,
	cnpj			varchar(20)	not null,
	endereco		varchar(255)	not null,
	endereco_complemento	varchar(255)	null,
	bairro			varchar(150)	not null,
	cep			varchar(9)	not null,
	cidade			varchar(150)	not null,
	uf			varchar(2)	not null,
	primary key(cd_cliente)
	)
go

create table
Funcionario
	(
	cd_funcionario		integer 	not null	Identity(1,1),
	nm_funcionario		varchar(255)	not null,
	login_funcionario	varchar (20)	not null,
	senha_funcionario	varchar (10)	not null,
	primary key(cd_funcionario)
	)
go
	
create table
Papel
	(
	cd_papel		integer 	not null	Identity(1,1),
	nm_papel		varchar (100)	not null,
	primary key(cd_papel)
	)
go

create table
PapelFuncionario
	(
	cd_papelfuncionario	integer 	not null	Identity(1,1),
	cd_funcionario		integer 	not null,
	cd_papel		integer 	not null,
	primary key(cd_papelfuncionario)
	)
go

create table
Projeto
	(
	cd_projeto		integer 	not null	Identity(1,1),
	nm_projeto		varchar(255) 	not null,
	vl_horas		real	 	not null,
	vl_prazo		real	 	not null,
	cd_cliente		integer 	not null,
	primary key(cd_projeto)
	)
go

create table
Fases
	(
	cd_fase			integer 	not null	Identity(1,1),
	nm_fase			varchar(100) 	not null,
	cd_projeto		integer 	not null,
	vl_horas		real	 	not null,
	vl_prazo		real	 	not null,
	primary key(cd_fase)
	)
go

create table
Entregavel
	(
	cd_entregavel		integer 	not null	Identity(1,1),
	nm_entregavel		varchar(100)	not null,
	cd_fase 		integer		not null,
	vl_horas		real	 	not null,
	vl_prazo		real	 	not null,
	primary key(cd_entregavel)
	)
go

create table
PapelProjeto
	(
	cd_papelprojeto		integer 	not null	Identity(1,1),
	cd_projeto		integer 	not null,
	cd_papel		integer 	not null,
	vl_qtde			integer 	not null,
	primary key(cd_papelprojeto)
	)
go

create table
PapelFuncionarioProjeto
	(
	cd_papelfuncionarioprojeto	integer	not null	Identity(1,1),
	cd_papelfuncionario		integer not null,
	cd_papelprojeto			integer not null,
	vl_horas			real	not null,
	primary key (cd_papelfuncionarioprojeto)
	)
go

create table
Atividade
	(
	cd_atividade		integer 	not null 	Identity(1,1),
	nm_atividade		varchar(500)	not null,
	cd_entregavel		integer 	not null,
	cd_papelfuncionarioprojeto	integer	not null,
	ds_atividade		text		not null,
	dt_inicio		datetime	not null,
	dt_termino		datetime	not null,
	vl_duracao		real		not null,
	primary key (cd_atividade)
	)
go

-- abd_CCDES#2 - FK


use CCDES
go


alter table		
PapelFuncionario	add
 constraint	[fk_funcionario]
 foreign key 	(cd_funcionario)
 references	Funcionario(cd_funcionario),

 constraint	[fk_papel]
 foreign key	(cd_papel)
 references	Papel(cd_papel)
GO

alter table		
Projeto			add
 constraint	[fk_cliente]
 foreign key 	(cd_cliente)
 references	Cliente(cd_cliente)
GO

alter table		
PapelProjeto		add
 constraint	[fk_projeto]
 foreign key 	(cd_projeto)
 references	Projeto(cd_projeto),

 constraint	[fk_papelprojeto]
 foreign key	(cd_papel)
 references	Papel(cd_papel)
GO

alter table		
PapelFuncionarioProjeto	add
 constraint	[fk_papelfuncionarioprojeto]
 foreign key 	(cd_papelfuncionario)
 references	PapelFuncionario(cd_papelfuncionario),

 constraint	[fk_papelprojetofuncionario]
 foreign key	(cd_papelprojeto)
 references	PapelProjeto(cd_papelprojeto)
GO

alter table
Fases			add
 constraint	[fk_fasesprojeto]
 foreign key	(cd_projeto)
 references	Projeto(cd_projeto)
GO

alter table
Entregavel		add
 constraint	[fk_faseentregavel]
 foreign key	(cd_fase)
 references	Fases(cd_fase)
GO

alter table
Atividade		add
 constraint	[fk_atividadeentregavel]
 foreign key	(cd_entregavel)
 references	Entregavel(cd_entregavel),

 constraint	[fk_atividadepapelfuncionarioprojeto]
 foreign key	(cd_papelfuncionarioprojeto)
 references	PapelFuncionarioProjeto(cd_papelfuncionarioprojeto)
GO


-- abd_CCDES#3 - Clientes
use CCDES

insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Ulysses Neto S/A.','33732190002-02','Av. Liberdade, 765','','Liberdade','6534-002','So Paulo','SP')
insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Alessandra da Rocha Ventura ME.','5106200026-02','Av. Paulista, 1265','2 andar, Cj 211','Cerqueira Csar','3225-000','So Paulo','SP')
insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Auto Posto Pirapora Ltda.','610520300001-28','Av. Triunfo Do, 18.191','','Centro','28534-090','Pirapora','SP')
insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Valeo Sistemas Automotivos Ltda.','30253390028-01','R. Pe. Joo Moreira, 51','','Pimentas','9032-000','Guarulhos','SP')
insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Div-Som Isolamento Acstico Ltda.','517006640001-02','R. Cato, 876','','Vila Romana','5049-000','So Paulo','SP')
insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Leo Madeiras Ltda.','13739190001-01','R. Gasmetro Do, 1023','','Pq. Novo Mundo','99571-011','Fortaleza','CE')
insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Jorsil Industrias Ltda.','50001510001-01','R. Domingos Delgado, 107','','Vila Souza','02881-070','Rio Verde','GO')
insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Tnl Contax S/A.','48785510021-80','Estrada das Amoreiras, S/N','Lote A','Estradinha','2532-901','Porto Alegre','RS')
insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Latcinios Rei Charles Ltda.','557660330001-02','Estrada dos Latcinios, 2100','Lote 5','Patarra','93551-000','Itapeva','MG')
insert into Cliente(nm_cliente,cnpj,endereco,endereco_complemento,bairro,cep,cidade,uf) values ('Net Internet S/A.','527005850003-02','Viela Das Estrelas, 03','Lote 2 - Casa 21','Centro','94158-015','Poos de Caldas','MG')
go

-- abd_CCDES#4 - Projeto
use CCDES

insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto de Estacionamento',65,1,1)
insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto de RH',80,3,2)
insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto de Posto de Gasolina',90,5,3)
insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto de Desenvolvimento de peas',120,2,4)
insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto de Material Acstico',45,7,5)
insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto de Marcenaria',30,10,6)
insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto Farmaceutica',20,15,7)
insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto de Contabilidade',55,8,8)
insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto de gado leiteiro',70,5,9)
insert into Projeto(nm_projeto,vl_horas,vl_prazo,cd_cliente) values ('Gesto de LAN House',56,4,10)
go

-- abd_CCDES#5 - Funcionario
use CCDES

insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Joo Batista','Joao.Batista','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Jos Siqueira','Jose.Siqueira','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Maria Luiza','Maria.Luiza','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Charles Lemes','Charles.Lemes','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Cristian Bueno','Cristian.Bueno','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Edson Novaes','Edson.Novaes','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Smela Cristina','Samela.Cristina','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Diego Bonf','Diego.Bonfa','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Ulysses Neto','Ulysses.Neto','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Pedro Paulo','Pedro.Paulo','inicio00')
insert into Funcionario(nm_funcionario,login_funcionario,senha_funcionario) values ('Master','Master.Master','inicio00')

go

-- abd_CCDES#6 - Papel
use CCDES

insert into Papel(nm_papel) values ('Gerente')
insert into Papel(nm_papel) values ('Analista Senior')
insert into Papel(nm_papel) values ('Analista Pleno')
insert into Papel(nm_papel) values ('Analista Junior')
insert into Papel(nm_papel) values ('Programador')
insert into Papel(nm_papel) values ('Diretor')
insert into Papel(nm_papel) values ('Desenvolvedor')
insert into Papel(nm_papel) values ('Testador')
insert into Papel(nm_papel) values ('Coordenador')
insert into Papel(nm_papel) values ('Estagiario')

go

-- abd_CCDES#7 - Fases
use ccdes

insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',1,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',1,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',1,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',1,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',1,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',1,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',1,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',1,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',1,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',1,100,3)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',2,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',2,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',2,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',2,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',2,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',2,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',2,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',2,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',2,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',2,100,3)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',3,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',3,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',3,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',3,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',3,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',3,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',3,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',3,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',3,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',3,100,3)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',4,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',4,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',4,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',4,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',4,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',4,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',4,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',4,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',4,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',4,100,3)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',5,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',5,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',5,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',5,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',5,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',5,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',5,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',5,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',5,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',5,100,3)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',6,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',6,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',6,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',6,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',6,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',6,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',6,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',6,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',6,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',6,100,3)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',7,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',7,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',7,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',7,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',7,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',7,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',7,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',7,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',7,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',7,100,3)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',8,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',8,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',8,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',8,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',8,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',8,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',8,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',8,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',8,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',8,100,3)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',9,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',9,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',9,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',9,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',9,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',9,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',9,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',9,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',9,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',9,100,3)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('fase do projeto requisitos',10,80,1)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Analise dos requisitos',10,50,6)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Validar os Requisitos',10,30,9)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Desenvolvimento dos Requisitos ',10,120,5)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Testar funo Requisitos',10,75,4)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Apresentar Modelo',10,40,7)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Implantar Modelo',10,65,8)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Acompanhar instalao',10,90,10)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Verificar erros',10,75,15)
insert into Fases(nm_fase,cd_projeto,vl_horas,vl_prazo) values ('Fim de processo do Modelo',10,100,3)

go

-- abd_CCDES#8 - PapelFuncionario
use CCDES

insert into papelfuncionario (cd_funcionario, cd_papel) values (1,10)
insert into papelfuncionario (cd_funcionario, cd_papel) values (1,8)
insert into papelfuncionario (cd_funcionario, cd_papel) values (2,5)
insert into papelfuncionario (cd_funcionario, cd_papel) values (2,7)
insert into papelfuncionario (cd_funcionario, cd_papel) values (2,4)
insert into papelfuncionario (cd_funcionario, cd_papel) values (3,2)
insert into papelfuncionario (cd_funcionario, cd_papel) values (3,9)
insert into papelfuncionario (cd_funcionario, cd_papel) values (4,8)
insert into papelfuncionario (cd_funcionario, cd_papel) values (4,4)
insert into papelfuncionario (cd_funcionario, cd_papel) values (5,2)
insert into papelfuncionario (cd_funcionario, cd_papel) values (5,1)
insert into papelfuncionario (cd_funcionario, cd_papel) values (5,9)
insert into papelfuncionario (cd_funcionario, cd_papel) values (6,6)
insert into papelfuncionario (cd_funcionario, cd_papel) values (6,1)
insert into papelfuncionario (cd_funcionario, cd_papel) values (7,1)
insert into papelfuncionario (cd_funcionario, cd_papel) values (7,9)
insert into papelfuncionario (cd_funcionario, cd_papel) values (7,2)
insert into papelfuncionario (cd_funcionario, cd_papel) values (8,3)
insert into papelfuncionario (cd_funcionario, cd_papel) values (8,5)
insert into papelfuncionario (cd_funcionario, cd_papel) values (8,7)
insert into papelfuncionario (cd_funcionario, cd_papel) values (9,6)
insert into papelfuncionario (cd_funcionario, cd_papel) values (10,10)

go

-- abd_CCDES#9 - PapelProjeto
use CCDES

insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (1,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (1,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (1,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (1,8,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (2,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (2,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (2,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (2,8,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (3,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (3,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (3,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (3,8,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (4,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (4,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (4,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (4,8,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (5,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (5,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (5,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (5,8,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (6,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (6,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (6,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (6,8,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (7,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (7,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (7,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (7,8,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (8,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (8,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (8,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (8,8,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (9,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (9,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (9,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (9,8,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (10,1,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (10,2,1)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (10,5,2)
insert into PapelProjeto (cd_projeto,cd_papel,vl_qtde) values (10,8,1)

go

-- abd_CCDES#10 - Entregavel
USE CCDES

insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',1,120,19)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',1,140,22)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',2,130,21)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',3,50,8)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',4,29,4)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',4,79,12)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',4,56,9)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',5,95,15)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',5,65,10)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',5,46,7)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',7,32,5)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',7,122,19)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',7,45,7)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',8,73,11)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',8,91,14)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',8,82,13)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',9,28,4)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',9,64,10)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',9,29,4)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',10,27,4)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',10,92,14)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',10,72,11)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',11,73,11)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',11,74,12)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',12,75,12)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',13,76,12)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',14,77,12)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',14,78,12)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',14,79,12)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',15,80,13)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',15,81,13)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',15,82,13)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',17,83,13)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',17,84,13)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',17,85,13)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',18,86,13)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',18,87,14)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',18,88,14)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',19,89,14)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',19,90,14)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',19,91,14)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',20,92,14)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',20,93,15)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',20,94,15)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',21,95,15)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',21,96,15)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',22,97,15)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',23,98,15)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',24,99,16)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',24,100,16)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',24,101,16)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',25,102,16)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',25,103,16)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',25,104,16)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',27,105,17)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',27,106,17)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',27,107,17)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',28,108,17)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',28,109,17)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',28,110,17)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',29,111,18)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',29,112,18)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',29,113,18)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',30,114,18)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',30,115,18)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',30,116,18)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',31,117,19)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',31,118,19)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',32,119,19)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',33,120,19)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',34,121,19)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',34,122,19)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',34,123,19)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',35,124,20)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',35,125,20)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',35,126,20)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',37,127,20)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',37,128,20)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',37,129,20)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',38,130,21)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',38,131,21)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',38,132,21)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',39,133,21)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',39,134,21)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',39,135,21)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',40,136,22)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',40,137,22)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',40,138,22)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',41,139,22)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',41,140,22)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',42,141,22)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',43,142,23)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',44,143,23)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',44,144,23)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',44,145,23)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',45,146,23)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',45,147,23)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',45,148,24)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',47,149,24)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',47,150,24)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',47,151,24)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',48,152,24)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',48,153,24)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',48,154,25)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',49,155,25)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',49,156,25)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',49,157,25)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',50,158,25)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',50,159,25)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',50,160,26)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',51,161,26)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',51,162,26)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',52,163,26)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',53,164,26)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',54,165,26)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',54,166,26)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',54,167,27)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',55,168,27)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',55,169,27)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',55,170,27)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',57,171,27)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',57,172,27)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',57,173,28)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',58,174,28)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',58,175,28)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',58,176,28)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',59,177,28)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',59,178,28)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',59,179,29)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',60,180,29)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',60,181,29)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',60,182,29)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',61,183,29)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',61,184,29)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',62,185,30)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',63,186,30)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',64,187,30)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',64,188,30)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',64,189,30)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',65,190,30)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',65,191,31)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',65,192,31)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',67,193,31)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',67,194,31)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',67,195,31)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',68,196,31)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',68,197,32)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',68,198,32)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',69,199,32)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',69,200,32)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',69,201,32)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',70,202,32)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',70,203,32)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',70,204,33)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',71,205,33)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',71,206,33)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',72,207,33)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',73,208,33)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',74,209,33)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',74,210,34)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',74,211,34)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',75,212,34)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',75,213,34)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',75,214,34)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',77,215,34)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',77,216,35)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',77,217,35)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',78,218,35)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',78,219,35)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',78,220,35)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',79,221,35)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',79,222,36)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',79,223,36)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',80,224,36)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',80,225,36)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',80,226,36)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',81,227,36)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',81,228,37)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',82,229,37)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',83,230,37)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',84,231,37)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',84,232,37)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',84,233,37)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',85,234,38)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',85,235,38)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',85,236,38)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',87,237,38)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',87,238,38)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',87,239,38)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',88,240,39)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',88,241,39)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',88,242,39)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',89,243,39)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',89,244,39)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',89,245,39)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',90,246,39)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',90,247,40)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',90,248,40)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Levantamento de Requisitos',91,249,40)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentar Requisitos',91,250,40)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Requisitos',92,251,40)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Prototipo',93,252,40)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Codificao dos Requisitos',94,253,41)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Analisar codificao',94,254,41)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar codificao',94,255,41)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de codificao',95,256,41)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Teste de Estress do Sistema',95,257,41)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Testes',95,258,41)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software no Servidor',97,259,42)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Instalao do Software nos Terminais',97,260,42)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Instalao',97,261,42)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Treinamento de Pessoal',98,262,42)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Durao de Treinamento por Departamento',98,263,42)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validar Treinamento',98,264,42)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao do Software Instalado',99,265,43)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Verificao de Erros no Software',99,266,43)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao do Sistema',99,267,43)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Processo de Documentao do Sistema',100,268,43)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Documentao de Regras do Sistema',100,269,43)
insert into Entregavel(Nm_entregavel,cd_fase,vl_horas,vl_prazo) values ('Validao da Documentao',100,270,43)

go

-- abd_CCDES#11 - PapelFuncionarioProjeto
USE CCDES

insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (11,1,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (17,2,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,3,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,3,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,4,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (15,5,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (17,6,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,7,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,7,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,8,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (15,9,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (10,10,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,11,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,11,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,12,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (14,13,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (17,14,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,15,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,15,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,16,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (14,17,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (17,18,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,19,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,19,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,20,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (14,21,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (10,22,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,23,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,23,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,24,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (11,25,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (17,26,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,27,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,27,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,28,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (14,29,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (17,30,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,31,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,31,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,32,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (14,33,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (6,34,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,35,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,35,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,36,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (14,37,20)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (6,38,40)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (3,39,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (19,39,80)
insert into PapelFuncionarioProjeto(cd_papelfuncionario,cd_papelprojeto,vl_horas) values (2,40,80)

go

-- abd_CCDES#12 - atividade
use ccdes

insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Levantamentar Requisitos','1','2','Entrevista com usurio','1/3/2008 08:00','3/1/2008 16:24','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Documentar Requisitos','2','2','Documentar Requisitos','1/3/2008 08:43','3/1/2008 17:07','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Requisitos','3','5','Validar Requisitos','1/4/2008 08:47','3/2/2008 17:11','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Requisitos','3','1','Validar Requisitos','3/2/2008 08:47','3/2/2008 17:11','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Prototipar','4','4','Prototipar','1/5/2008 08:51','3/3/2008 17:15','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Codificar Requisitos','5','3','Codificar Requisitos','1/6/2008 08:56','3/4/2008 17:19','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Analisar codificao','6','5','Analisar codificao','1/7/2008 09:00','3/5/2008 17:24','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar codificao','7','5','Validar codificao','1/8/2008 09:04','3/6/2008 17:28','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Testar codigo','8','5','Testar codigo','1/9/2008 09:09','3/7/2008 17:32','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Testar de stress do Sistema','9','5','Testar de stress do Sistema','1/10/2008 09:13','3/8/2008 17:37','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Testes','10','2','Validar Testes','1/11/2008 09:17','3/9/2008 17:41','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Instalar Software no Servidor','11','2','Instalar Software no Servidor','1/12/2008 09:22','3/10/2008 17:45','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Instalar Software nos Terminais','12','2','Instalar Software nos Terminais','1/13/2008 09:26','3/11/2008 17:50','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Instalao','13','5','Validar Instalao','1/14/2008 09:30','3/12/2008 17:54','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Instalao','13','2','Validar Instalao','1/14/2008 09:30','3/12/2008 17:54','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Treinar Pessoal','14','2','Treinar Pessoal','1/15/2008 09:35','3/13/2008 17:58','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Treinamento','15','2','Validar Treinamento','1/16/2008 09:39','3/14/2008 18:03','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Verificar Software Instalado','17','5','Verificar Software Instalado','1/17/2008 09:43','3/15/2008 18:07','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Verificar Erros no Software','18','5','Verificar Erros no Software','1/18/2008 09:48','3/16/2008 18:11','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Sistema','19','3','Validar Sistema','1/19/2008 09:52','3/17/2008 18:16','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Sistema','19','5','Validar Sistema','3/10/2008 09:52','3/17/2008 18:16','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Processar Documentao do Sistema','20','2','Processar Documentao do Sistema','1/20/2008 09:56','3/18/2008 18:20','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Documentar de Regras do Sistema','21','2','Documentar de Regras do Sistema','1/21/2008 10:00','3/19/2008 18:24','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Documentao','22','1','Validar Documentao','1/22/2008 10:05','3/20/2008 18:29','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Levantamentar Requisitos','23','7','Entrevista com usurio','1/3/2008 08:00','3/1/2008 16:24','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Documentar Requisitos','24','7','Documentar Requisitos','1/3/2008 08:43','3/1/2008 17:07','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Requisitos','25','10','Validar Requisitos','1/4/2008 08:47','3/2/2008 17:11','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Requisitos','25','6','Validar Requisitos','3/2/2008 08:47','3/2/2008 17:11','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Prototipar','26','9','Prototipar','1/5/2008 08:51','3/3/2008 17:15','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Codificar Requisitos','27','8','Codificar Requisitos','1/6/2008 08:56','3/4/2008 17:19','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Analisar codificao','28','10','Analisar codificao','1/7/2008 09:00','3/5/2008 17:24','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar codificao','29','10','Validar codificao','1/8/2008 09:04','3/6/2008 17:28','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Testar codigo','30','10','Testar codigo','1/9/2008 09:09','3/7/2008 17:32','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Testar de stress do Sistema','31','10','Testar de stress do Sistema','1/10/2008 09:13','3/8/2008 17:37','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Testes','32','7','Validar Testes','1/11/2008 09:17','3/9/2008 17:41','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Instalar Software no Servidor','33','7','Instalar Software no Servidor','1/12/2008 09:22','3/10/2008 17:45','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Instalar Software nos Terminais','34','7','Instalar Software nos Terminais','1/13/2008 09:26','3/11/2008 17:50','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Instalao','35','10','Validar Instalao','1/14/2008 09:30','3/12/2008 17:54','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Instalao','35','7','Validar Instalao','1/14/2008 09:30','3/12/2008 17:54','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Treinar Pessoal','36','7','Treinar Pessoal','1/15/2008 09:35','3/13/2008 17:58','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Treinamento','37','7','Validar Treinamento','1/16/2008 09:39','3/14/2008 18:03','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Verificar Software Instalado','39','10','Verificar Software Instalado','1/17/2008 09:43','3/15/2008 18:07','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Verificar Erros no Software','40','10','Verificar Erros no Software','1/18/2008 09:48','3/16/2008 18:11','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Sistema','41','8','Validar Sistema','1/19/2008 09:52','3/17/2008 18:16','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Sistema','41','10','Validar Sistema','3/10/2008 09:52','3/17/2008 18:16','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Processar Documentao do Sistema','42','7','Processar Documentao do Sistema','1/20/2008 09:56','3/18/2008 18:20','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Documentar de Regras do Sistema','43','7','Documentar de Regras do Sistema','1/21/2008 10:00','3/19/2008 18:24','1')
insert into Atividade(nm_atividade,cd_entregavel,cd_papelfuncionarioprojeto,ds_atividade,dt_inicio,dt_termino,vl_duracao) values ('Validar Documentao','44','6','Validar Documentao','1/22/2008 10:05','3/20/2008 18:29','1')

go

