-- =============================================
-- Nome:	CRISTIAN BUENO
-- RA:		502.895/7
-- =============================================

USE master
GO

DROP DATABASE 	Prova_AC_5028957
GO

CREATE DATABASE Prova_AC_5028957
GO

use prova_ac_5028957
go

-- CRIANDO TABELAS
CREATE TABLE
Cliente
	(
	clienteid		integer 	not null	Identity(1,1),
	razao_social		nvarchar(200)	null,
	nome_fantasia		nvarchar(200)	null,
	cnpj			nvarchar(20)	null,
	telefone		nvarchar(20)	null,
	endereco_rua		nvarchar(250)	null,
	endereco_bairro		nvarchar(100)	null,
	endereco_cep		nvarchar(50)	null,
	endereco_cidade		nvarchar(100)	null,
	endereco_estado		nvarchar(100)	null,
	endereco_pais		nvarchar(100)	null,
	email			nvarchar(100)	null,
	PRIMARY KEY(clienteid)
	)
GO

CREATE TABLE
Lista_Preco
	(
	lista_precoid	int		not null	Identity (1,1),
	nome		nvarchar(200)	not null,
	data_inicio	datetime	not null,
	data_termino	datetime	not null,
	PRIMARY KEY(lista_precoid)
	)
GO

CREATE TABLE
Unidade_Venda
	(
	unidade_vendaid	int		not null	Identity(1,1),
	nome		nvarchar(200)	not null,
	PRIMARY KEY (unidade_vendaid)
	)
GO

CREATE TABLE
Produto
	(
	produtoid		int		not null	Identity(1,1),
	nome			nvarchar(200)	not null,
	preco_referencia	float		not null,
	unidade_venda_padraoid	int,
	PRIMARY KEY (produtoid)
	)
GO

CREATE TABLE
Oportunidade
	(
	oportunidadeid			int		not null	Identity(1,1),
	topico				nvarchar(200)	not null,
	data_fechamento_estimada	datetime	null,
	valor_total_estimado		float	null,
	clienteid			int,
	lista_precoid			int,
	PRIMARY KEY (oportunidadeid)
	)
GO

CREATE TABLE
Item_Lista_Preco
	(
	item_lista_precoid	int		not null	Identity(1,1),
	lista_precoid		int		not null,
	produtoid		int		not null,
	unidade_vendaid		int		not null,
	preco_venda		float		not null,
	PRIMARY KEY (item_lista_precoid)
	)
GO

CREATE TABLE
Produto_Oportunidade
	(
	produto_oportunidadeid	int	not null	Identity(1,1),
	oportunidadeid		int	not null,
	item_lista_precoid	int	not null,
	preco_venda_unit	float	not null,
	quantidade		int	not null,
	valor_desconto_manual	float	null,
	preco_final		float	not null,
	PRIMARY KEY (produto_oportunidadeid)
	)
GO

-- ALTERANDO TABELAS E ADICIONANDO FK
ALTER TABLE
Oportunidade	ADD
 CONSTRAINT	[Cliente_Oportunidade_FK1]
 FOREIGN KEY	(clienteid)
 REFERENCES	Cliente(clienteid),

 CONSTRAINT	[Lista_Preco_Oportunidade_FK1]
 FOREIGN KEY	(lista_precoid)
 REFERENCES	Lista_Preco(lista_precoid)
GO



ALTER TABLE
Produto		ADD
 CONSTRAINT	[Unidade_Venda_Produto_FK1]
 FOREIGN KEY	(unidade_venda_padraoid)
 REFERENCES	Unidade_Venda(unidade_vendaid)
GO



ALTER TABLE
Item_Lista_Preco	ADD
 CONSTRAINT	[Unidade_Venda_Item_Lista_Preco_FK1]
 FOREIGN KEY	(unidade_vendaid)
 REFERENCES	Unidade_Venda(unidade_vendaid),

 CONSTRAINT	[Produto_Item_Lista_Preco_FK1]
 FOREIGN KEY	(produtoid)
 REFERENCES	Produto(produtoid),

 CONSTRAINT	[Lista_Preco_Item_Lista_Preco_FK1]
 FOREIGN KEY	(lista_precoid)
 REFERENCES	Lista_Preco(lista_precoid)
GO


ALTER TABLE
Produto_Oportunidade	ADD
 CONSTRAINT	[Item_Lista_Preco_Produto_Oportunidade_FK1]
 FOREIGN KEY	(item_lista_precoid)
 REFERENCES	Item_Lista_Preco(item_lista_precoid),

 CONSTRAINT	[Oportunidade_Produto_Oportunidade_FK1]
 FOREIGN KEY	(oportunidadeid)
 REFERENCES	Oportunidade(oportunidadeid)
GO
