/*fornecedor*/
create table fornecedor(
id_fornecedor int not null identity(1,1),
nome_fornecedor varchar(250) not null,
cnpj varchar(18) not null
)
/*requisitante*/
create table requisitante(
id_requisitante int not null identity(1,1),
nome_requisitante varchar(250) not null,
)
/*produto*/
create table produto(
id_produto int not null identity(1,1),
nome_produto varchar(250) not null
)
/*requisio*/
create table requisicao(
id_requisicao int not null identity(1,1),
nome_requisicao varchar(250) not null,
data_requisicao datetime not null,
data_fechamento datetime null,
id_requisitante int null,
status int not null
)
/*produto requisio*/
create table produto_requisicao(
id_produto_requisicao int not null identity(1,1),
id_requisicao int not null,
id_produto int not null,
quantidade int not null
)
/*fornecedor requisicao*/
create table fornecedor_requisicao(
id_fornecedor_requisicao int not null identity(1,1),
id_fornecedor int not null,
id_requisicao int not null,
status int not null
)
/*fornecedor produto requisio OU COTAO*/
create table fornecedor_produto_requisicao(
id_fornecedor_produto_requisicao int not null identity(1,1),
id_produto_requisicao int not null,
id_fornecedor_requisicao int not null,
valor float null
)

/******* primary keys *******/
ALTER TABLE fornecedor ADD CONSTRAINT PK_fornecedor PRIMARY KEY (id_fornecedor)
ALTER TABLE requisitante ADD CONSTRAINT PK_requisitante PRIMARY KEY (id_requisitante)
ALTER TABLE produto ADD CONSTRAINT PK_produto PRIMARY KEY (id_produto)
ALTER TABLE requisicao ADD CONSTRAINT PK_requisicao PRIMARY KEY (id_requisicao)

ALTER TABLE produto_requisicao ADD CONSTRAINT PK_produto_requisicao PRIMARY KEY (id_produto_requisicao)
ALTER TABLE fornecedor_requisicao ADD CONSTRAINT PK_fornecedor_requisicao PRIMARY KEY (id_fornecedor_requisicao)
ALTER TABLE fornecedor_produto_requisicao ADD CONSTRAINT PK_fornecedor_produto_requisicao PRIMARY KEY (id_fornecedor_produto_requisicao)



/******* foreigners keys *******/
ALTER TABLE produto_requisicao
ADD CONSTRAINT FK1_produto_requisicao FOREIGN KEY (id_produto)
    REFERENCES produto (id_produto) 

ALTER TABLE produto_requisicao
ADD CONSTRAINT FK2_produto_requisicao FOREIGN KEY (id_requisicao)
    REFERENCES requisicao (id_requisicao) 

ALTER TABLE fornecedor_requisicao
ADD CONSTRAINT FK1_fornecedor_requisicao FOREIGN KEY (id_fornecedor)
    REFERENCES fornecedor (id_fornecedor) 

ALTER TABLE fornecedor_requisicao
ADD CONSTRAINT FK2_fornecedor_requisicao FOREIGN KEY (id_requisicao)
    REFERENCES requisicao (id_requisicao) 

ALTER TABLE fornecedor_produto_requisicao
ADD CONSTRAINT FK1_fornecedor_produto_requisicao FOREIGN KEY (id_produto_requisicao)
    REFERENCES produto_requisicao (id_produto_requisicao) 

ALTER TABLE fornecedor_produto_requisicao
ADD CONSTRAINT FK2_fornecedor_produto_requisicao FOREIGN KEY (id_fornecedor_requisicao)
    REFERENCES fornecedor_requisicao (id_fornecedor_requisicao) 

ALTER TABLE requisicao
ADD CONSTRAINT FK1_requisitante_requisicao FOREIGN KEY (id_requisitante)
    REFERENCES requisitante (id_requisitante) 