/*
	Programa que estrutura e manipula Fila circular
*/

#include<time.h>
#include<conio.h>
#include<stdio.h>
#include<stdlib.h>

#define TAM 5

// definindo Fila Circular
struct fila
{
	int vetor[TAM];
	int ini;
	int fim;
	int queueFull;
};

// declarando as funes
int menu (void);
int solicita_valor(void);

void reset_fila (struct fila *f);
void mostra_fila (struct fila *f);
int size (struct fila *f);
int isFull (struct fila *f);
int isEmpty (struct fila *f);
int enQueue (struct fila *f, int);
int deQueue (struct fila *f);
int front (struct fila *f);

int main ()
{
    int elem, menu_opcao, retorno;
	struct fila f;
	reset_fila (&f);
    do
	{
	    clrscr();
	    menu_opcao = menu();
		if (menu_opcao > 0)
		{
			switch (menu_opcao)
			{
				case 1:
					if (isFull(&f) == 1)
					{
						printf ("\n\n\nFila CHEIA");
						printf ("\n\n\nPressione qualquer tecla para voltar ao MENU...");
						getch();
						break;
					}
					elem=solicita_valor();
					enQueue(&f,elem);
					break;
				case 2:
					retorno=size(&f);
					printf ("\n\n\nExistem %d iten(s) na FILA", retorno);
					printf ("\n\n\nPressione qualquer tecla para voltar ao MENU...");
					getch();
					break;
				case 3:
					retorno=deQueue(&f);
					printf ("\n\n\nO item excluido foi %d: ", retorno);
					printf ("\n\n\nPressione qualquer tecla para voltar ao MENU...");
					getch();
					break;
				case 4:
					retorno=front(&f);
					if (retorno < 0) printf ("\n\n\nA fila esta VAZIA");
					else	printf ("\n\n\nO Ultimo valor da FILA eh %d: ", retorno);
					printf ("\n\n\nPressione qualquer tecla para voltar ao MENU...");
					getch();
					break;
				case 5:
					mostra_fila(&f);
					break;
			}
		}
		if (menu_opcao==0) break;
	}while (1);
	return 0;
}


// Reinicializando fila
void reset_fila (struct fila *f)
{
	f->ini=0;
	f->fim=0;
	f->queueFull=0;
}

// Verificando o tamanho da fila
int size (struct fila *f)
{
	if (f->fim >= f->ini  &&  !f->queueFull)//!f->queueFull  a mesma coisa que f->queue==0
	{
		return f->fim - f->ini;
	}
	else
	{
		return f->fim - f->ini + TAM;
	}
}

// Verifica se a fila est cheia. Retorno (Verdadeiro / Falso)
int isFull (struct fila *f)
{
	if (size(f) == TAM)	return 1;
	else				return 0;
}

// Verifica se a fila est vazia. Retorno (Verdadeiro / Falso)
int isEmpty (struct fila *f)
{
	if (size(f) == 0)		return 1;
	else				return 0;
}

// Acrescenta valor na fila
int enQueue (struct fila *f, int elem)
{
	if (f->queueFull!=0) 		return 0;
	else
	{
		f->vetor[f->fim]=elem;
		f->fim++;
		if (f->fim == TAM) 	f->fim=0;
		if (f->fim == f->ini)	f->queueFull=1;
		return 1;
	}
}

// Exclui valor na fila
int deQueue (struct fila *f)
{
	int aux = f->vetor[f->ini];
	f->ini++;
	if (f->ini == TAM) f->ini = 0;
	f->queueFull=0;
	return aux;
}

// Mostra tamanho da fila
int front (struct fila *f)
{
	if (isEmpty(f) == 1) 	return -1;
	else				return f->vetor[f->fim-1];
}

// Solicitando valor para incluso na fila
int solicita_valor(void)
{
	int elem;
	printf ("\n\n\nDigite valor: ");
	scanf ("%d", &elem);
	return elem;
}

// Construindo menu
int menu (void)
{
	int	menu_opcao;
	printf ("\n");
	printf ("                     ************************************\n");
	printf ("                     *                                  *\n");
	printf ("                     *              MENU                *\n");
	printf ("                     *                                  *\n");
	printf ("                     ************************************\n");
	printf ("                     *                                  *\n");
	printf ("                     *   1 - ADICIONAR ITEM NA FILA     *\n");
	printf ("                     *                                  *\n");
	printf ("                     *   2 - QTOS ITENS NA FILA         *\n");
	printf ("                     *                                  *\n");
	printf ("                     *   3 - EXCLUIR ITEM DA FILA       *\n");
	printf ("                     *                                  *\n");
	printf ("                     *   4 - MOSTRAR ULTIMO NA FILA     *\n");
	printf ("                     *                                  *\n");
	printf ("                     *   5 - MOSTRAR ITENS NA FILA      *\n");
	printf ("                     *                                  *\n");
	printf ("                     ************************************\n");
	printf ("                     *                                  *\n");
	printf ("                     *   0 - SAIR                       *\n");
	printf ("                     *                                  *\n");
	printf ("                     ************************************\n\n\n\n");
	printf ("Digite opcao do menu acima: ");
	do
	{
		scanf ("%d", &menu_opcao);
		if (menu_opcao <0 || menu_opcao >5)
		{
			printf ("\n\n\nOpcao INVALIDA\n\n\n");
			printf ("Digite opcao (1-5): ");
		}
	}while (menu_opcao <0 || menu_opcao >5);
	return menu_opcao;
}

void mostra_fila (struct fila *f)
{
	int aux, cont;
	aux = f->ini;
	printf ("\n\n\n");
	if (isEmpty(f) != 1)
	{
		for (cont=0; cont < size(f); cont++)
		{
			if ( aux >= TAM ) aux=0;
			printf ("posicao %d - %d\n", aux+1, f->vetor[aux]);
			aux++;
		}
	}
	else	printf ("Fila Vazia");

	printf ("\n\n\nPressione qualquer tecla, para voltar ao MENU...");
	getch();
}
