/*
	Programa que estrutura e manipula um pilha
*/

#include<time.h>
#include<conio.h>
#include<stdio.h>
#include<stdlib.h>

#define TAM 5

// prototipos das funoes
int 	menu 	(void);
int		push 	(int);
int		pop		(void);
int		top		(void);
int		size	(void);
int		solicita_valor(void);
void	mostra_pilha(void);

// estrutura de pilha

struct pilha_int
{
	int vetor[TAM];
	int topo;
} pi;	// nome da varivel que tem a estrutura do vetor


int main(void)
{
    int vetor[TAM], elem, menu_opcao, retorno;
    do
	{
	    clrscr();
	    menu_opcao = menu();
		if (menu_opcao > 0)
		{
			switch (menu_opcao)
			{
				case 1:
					if (size() < TAM)
					{
						elem=solicita_valor();
						retorno=push(elem);
						printf ("\n\nValor inserido com sucesso");
						printf ("\n\n\nPressione qualquer tecla para continuar..."); getch();
					}
					else
					{
						printf ("\n\nPILHA cheia!");
						printf ("\n\n\nPressione qualquer tecla para continuar..."); getch();
					}
					break;
				case 2:
					retorno=size();
					printf ("\n\n\nO tamanho autal da pilha eh %d", retorno);
					getch(); printf ("\n\n\nPressione qualquer tecla para continuar...");
					break;
				case 3:
					if (size()>0)
					{
						retorno=pop();
						printf ("\n\n\nO elemento retirado foi %d", retorno);
						printf ("\n\n\nPressione qualquer tecla para continuar..."); getch();
					}
					else
					{
						printf ("\n\n\nOpcao INVALIDA\n\n\n");
						printf ("\n\n\nPressione qualquer tecla para continuar..."); getch();
					}
					break;
				case 4:
					if (size() >0)
					{
						retorno=top();
						printf ("\n\n\nO elemento do topo da pilha eh: %d", retorno);
						printf ("\n\n\nPressione qualquer tecla para continuar..."); getch();
					}
					else
					{
						printf ("\n\n\nOpcao INVALIDA\n\n\n");
						printf ("\n\n\nPressione qualquer tecla para continuar..."); getch();
					}
					break;
			}
		}
		if (menu_opcao==0) break;
	}while (1);
	return 0;
}

int solicita_valor(void)
{
	int elem;
	printf ("Digite valor: ");
	scanf ("%d", &elem);
	return elem;
}

void mostra_pilha(void)
{
	if (size()<=0) printf ("PILHA VAZIA");
	else{
		printf ("PILHA: ");
		for (int cont=0; cont < size(); cont++)
		{
			printf ("%d", pi.vetor[cont]);
			if (cont < (size()-1)) printf (" - ");
		}
	    }
	printf ("\n\n\n\n");
}

// definindo o menu
int menu (void)
{
	int	menu_opcao;
	printf ("\n");
	printf ("                     ************************************\n");
	printf ("                     *                                  *\n");
	printf ("                     *              MENU                *\n");
	printf ("                     *                                  *\n");
	printf ("                     ************************************\n");
	printf ("                     *                                  *\n");
	printf ("                     *   1 - ADICIONAR ITEM NA PILHA    *\n");
	printf ("                     *                                  *\n");
	printf ("                     *   2 - MOSTRAR TAMANHO DA PILHA   *\n");
	printf ("                     *                                  *\n");
	printf ("                     *   3 - EXCLUIR ITEM DA PILHA      *\n");
	printf ("                     *                                  *\n");
	printf ("                     *   4 - MOSTRAR ITEM DO TOPO       *\n");
	printf ("                     *                                  *\n");
	printf ("                     ************************************\n");
	printf ("                     *                                  *\n");
	printf ("                     *   0 - SAIR                       *\n");
	printf ("                     *                                  *\n");
	printf ("                     ************************************\n\n\n\n\n\n");
	mostra_pilha();
	printf ("Digite opcao do menu acima: ");
	do
	{
		scanf ("%d", &menu_opcao);
		if (menu_opcao <0 || menu_opcao >4)
		{
			printf ("\n\n\nOpcao INVALIDA\n\n\n");
			printf ("Digite opcao (1-4): ");
		}
	}while (menu_opcao <0 || menu_opcao >4);
	return menu_opcao;
}

// funcao " push "
int push (int elem)
{
	if(pi.topo >= TAM)
		return 0; // retorna 0 - FALSO
	pi.vetor[pi.topo]=elem;
	pi.topo ++;
	return 1; // retorna 1 - VERDADEIRO
}

//funcao " topo "
int top ()
{
	return pi.vetor[pi.topo-1];
}

// funcao " size "
int size ()
{
	return pi.topo;
}

//funcao pop
int pop (void)
{
	pi.topo --;
	return pi.vetor[pi.topo];
}
